"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "program", {
    enumerable: true,
    get: function() {
        return program;
    }
});
const _express = /*#__PURE__*/ _interop_require_default(require("express"));
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _getFilteredListByPermission = require("@tamanu/shared/utils/getFilteredListByPermission");
const _crudHelpers = require("@tamanu/shared/utils/crudHelpers");
const _constants = require("@tamanu/constants");
const _sequelize = require("sequelize");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const program = _express.default.Router();
program.get('/:id', (0, _crudHelpers.simpleGet)('Program'));
program.put('/:id', (0, _crudHelpers.simplePut)('Program'));
program.post('/$', (0, _crudHelpers.simplePost)('Program'));
program.get('/$', (0, _expressasynchandler.default)(async (req, res)=>{
    req.checkPermission('list', 'Program');
    const { models, ability } = req;
    const records = await models.Program.findAll({
        order: [
            [
                'name',
                'ASC'
            ]
        ],
        include: [
            {
                association: 'surveys',
                where: {
                    surveyType: 'programs',
                    visibilityStatus: {
                        [_sequelize.Op.ne]: _constants.VISIBILITY_STATUSES.HISTORICAL
                    }
                }
            }
        ]
    });
    // Don't include programs that don't have any permitted survey to submit
    const canSubmit = (survey)=>ability.can('submit', survey);
    const hasAnySurveys = (programRecord)=>programRecord.surveys.some(canSubmit);
    const filteredRecords = records.filter(hasAnySurveys);
    const data = filteredRecords.map((x)=>x.forResponse());
    res.send({
        count: data.length,
        data
    });
}));
const programRelations = (0, _crudHelpers.permissionCheckingRouter)('read', 'Program');
programRelations.get('/:id/surveys', (0, _expressasynchandler.default)(async (req, res)=>{
    req.checkPermission('list', 'Survey');
    const { models, params, ability } = req;
    const records = await models.Survey.findAll({
        where: {
            programId: params.id,
            visibilityStatus: {
                [_sequelize.Op.ne]: _constants.VISIBILITY_STATUSES.HISTORICAL
            }
        },
        order: [
            [
                'name',
                'ASC'
            ]
        ]
    });
    const filteredRecords = (0, _getFilteredListByPermission.getFilteredListByPermission)(ability, records, 'submit');
    const data = filteredRecords.map((x)=>x.forResponse());
    res.send({
        count: data.length,
        data
    });
}));
program.use(programRelations);

//# sourceMappingURL=program.js.map