"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "translation", {
    enumerable: true,
    get: function() {
        return translation;
    }
});
const _express = /*#__PURE__*/ _interop_require_default(require("express"));
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _constants = require("@tamanu/constants");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const translation = _express.default.Router();
// Register a new string for translation
translation.post('/', (0, _expressasynchandler.default)(async (req, res)=>{
    // Everyone can interact with translations as long as logged in
    req.flagPermissionChecked();
    const { models: { TranslatedString }, body: { stringId, fallback } } = req;
    const translatedString = await TranslatedString.create({
        stringId,
        text: fallback,
        language: _constants.ENGLISH_LANGUAGE_CODE
    });
    res.send(translatedString);
}));

//# sourceMappingURL=translation.js.map