"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "initTimesync", {
    enumerable: true,
    get: function() {
        return initTimesync;
    }
});
const _timesimp = require("timesimp");
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _constants = require("@tamanu/constants");
const _logging = require("@tamanu/shared/services/logging");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const initTimesync = async ({ models, url })=>{
    _logging.log.info('Initializing timesync', {
        server: url
    });
    if (!_config.default.schedules.timeSync.enabled) {
        await models.LocalSystemFact.set(_constants.FACT_TIME_OFFSET, '0');
    }
    return new _timesimp.Timesimp(async (err)=>{
        if (err) throw err;
        const us = await models.LocalSystemFact.get(_constants.FACT_TIME_OFFSET);
        if (!us) return null;
        return parseInt(us, 10);
    }, async (err, offset)=>{
        if (err) throw err;
        _logging.log.debug('Timesync offset updated (us)', {
            offset
        });
        await models.LocalSystemFact.set(_constants.FACT_TIME_OFFSET, offset.toString());
    }, async (err, body)=>{
        if (err) throw err;
        _logging.log.debug('Fetching timesync packet', {
            url,
            body
        });
        const http = await fetch(url, {
            signal: AbortSignal.timeout(10000),
            method: 'POST',
            body,
            headers: {
                'Content-Type': 'application/octet-stream'
            }
        }).catch((err)=>{
            _logging.log.error('Failed to fetch timesync packet', {
                error: err
            });
            throw err;
        });
        const response = Buffer.from(await http.arrayBuffer());
        _logging.log.debug('Got reply timesync packet', {
            url,
            response
        });
        return response;
    });
};

//# sourceMappingURL=initTimesync.js.map