"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "getPermittedSurveyIds", {
    enumerable: true,
    get: function() {
        return getPermittedSurveyIds;
    }
});
const _ability = require("@casl/ability");
const getPermittedSurveyIds = async (req, models)=>{
    // Number of surveys should not be too large, so it's ok to load all survey ids into the memory
    const surveys = await models.Survey.findAll({
        attributes: [
            'id'
        ]
    });
    // Use this list of permittedSurveyIds in the query to only grab the survey responses
    // user has permission to read
    return surveys.filter((survey)=>req.ability.can('read', (0, _ability.subject)('Survey', {
            id: survey.id
        }))).map((survey)=>survey.id);
};

//# sourceMappingURL=getPermittedSurveyIds.js.map