import { z } from 'zod';
/**
 * Formats a date as YYYY-MM-DD HH:MM:SS without milliseconds
 * This ensures compatibility with datetimeCustomValidation schema
 */
export declare const formatDateTimeForSchema: (date: Date) => string;
type MockInput<T extends z.ZodObject<any>> = {
    schema: T;
    mock: Record<string, any>;
    excludedFields?: (keyof z.infer<T>)[];
};
export declare const processMock: <T extends z.ZodObject<any>>({ schema, mock, excludedFields, }: MockInput<T>) => Record<string, any>;
export {};
