import { fake } from '../../fake/index.js';
export const createMedication = async ({ models: { Prescription, EncounterPrescription, PatientOngoingPrescription, EncounterPausePrescription, EncounterPausePrescriptionHistory }, encounterId, patientId, referenceDataId })=>{
    const prescription = await Prescription.create(fake(Prescription, {
        medicationId: referenceDataId
    }));
    const encounterPrescription = await EncounterPrescription.create(fake(EncounterPrescription, {
        encounterId,
        prescriptionId: prescription.id
    }));
    await PatientOngoingPrescription.create(fake(PatientOngoingPrescription, {
        patientId: patientId,
        prescriptionId: prescription.id
    }));
    await EncounterPausePrescription.create(fake(EncounterPausePrescription, {
        encounterPrescriptionId: encounterPrescription.id
    }));
    await EncounterPausePrescriptionHistory.create(fake(EncounterPausePrescriptionHistory, {
        encounterPrescriptionId: encounterPrescription.id
    }));
};

//# sourceMappingURL=medication.js.map