"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    ageDisplayFormatDefault: function() {
        return ageDisplayFormatDefault;
    },
    ageDisplayFormatSchema: function() {
        return ageDisplayFormatSchema;
    }
});
const _yup = /*#__PURE__*/ _interop_require_wildcard(require("yup"));
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
const NONNEGATIVE_INTEGER = _yup.number().integer().min(0);
const ageRangeLimitSchema = _yup.object({
    duration: _yup.object({
        years: NONNEGATIVE_INTEGER,
        months: NONNEGATIVE_INTEGER,
        days: NONNEGATIVE_INTEGER
    }).noUnknown(),
    exclusive: _yup.boolean()
});
const formatRangeSchema = _yup.object({
    min: ageRangeLimitSchema,
    max: ageRangeLimitSchema
}).required().test({
    name: 'ageDisplayFormat-range',
    test (range, ctx) {
        if (!range.min && !range.max) {
            return ctx.createError({
                message: `range in ageDisplayFormat must include either min or max, or both, got ${JSON.stringify(range)}`
            });
        }
        return true;
    }
});
const formatItemSchema = _yup.object({
    as: _yup.string().oneOf([
        'days',
        'weeks',
        'months',
        'years'
    ]).required(),
    range: formatRangeSchema
});
const ageDisplayFormatSchema = _yup.array(formatItemSchema).test({
    name: 'ageDisplayFormat-fallback',
    message: 'One of ranges in ‘ageDisplayFormat’ must have no maximum set. (It should be an open interval)',
    test: (formats)=>{
        if (formats === undefined) return true; // Don’t fail validation if falling back to default value
        return formats.some((f)=>f.range.max === undefined);
    }
});
const ageDisplayFormatDefault = [
    {
        as: 'days',
        range: {
            min: {
                duration: {
                    days: 0
                },
                exclusive: false
            },
            max: {
                duration: {
                    days: 8
                },
                exclusive: true
            }
        }
    },
    {
        as: 'weeks',
        range: {
            min: {
                duration: {
                    days: 8
                }
            },
            max: {
                duration: {
                    months: 1
                },
                exclusive: true
            }
        }
    },
    {
        as: 'months',
        range: {
            min: {
                duration: {
                    months: 1
                }
            },
            max: {
                duration: {
                    years: 2
                },
                exclusive: true
            }
        }
    },
    {
        as: 'years',
        range: {
            min: {
                duration: {
                    years: 2
                }
            }
        }
    }
];

//# sourceMappingURL=ageDisplayFormat.js.map