"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    ProgramDataElementSchema: function() {
        return ProgramDataElementSchema;
    },
    SurveySchema: function() {
        return SurveySchema;
    },
    SurveyScreenComponentSchema: function() {
        return SurveyScreenComponentSchema;
    },
    SurveyWithComponentsSchema: function() {
        return SurveyWithComponentsSchema;
    }
});
const _zod = require("zod");
const _constants = require("@tamanu/constants");
const ProgramDataElementSchema = _zod.z.object({
    id: _zod.z.string(),
    code: _zod.z.string().optional().nullable(),
    name: _zod.z.string().optional().nullable(),
    indicator: _zod.z.string().optional().nullable(),
    defaultText: _zod.z.string().optional().nullable(),
    defaultOptions: _zod.z.unknown().optional().nullable(),
    visualisationConfig: _zod.z.unknown().optional().nullable(),
    type: _zod.z.string().optional().nullable()
});
const SurveyScreenComponentSchema = _zod.z.object({
    id: _zod.z.string(),
    screenIndex: _zod.z.number().optional().nullable(),
    componentIndex: _zod.z.number().optional().nullable(),
    text: _zod.z.string().optional().nullable(),
    visibilityCriteria: _zod.z.string().optional().nullable(),
    validationCriteria: _zod.z.string().optional().nullable(),
    detail: _zod.z.string().optional().nullable(),
    config: _zod.z.string().optional().nullable(),
    options: _zod.z.string().optional().nullable(),
    calculation: _zod.z.string().optional().nullable(),
    visibilityStatus: _zod.z.string().optional().nullable(),
    dataElement: ProgramDataElementSchema.optional().nullable(),
    dataElementId: _zod.z.string().optional().nullable()
});
const SurveySchema = _zod.z.object({
    id: _zod.z.string(),
    name: _zod.z.string(),
    code: _zod.z.string(),
    surveyType: _zod.z.enum(_constants.SURVEY_TYPES)
});
const SurveyWithComponentsSchema = SurveySchema.extend({
    components: _zod.z.array(SurveyScreenComponentSchema).optional().nullable()
});

//# sourceMappingURL=survey.schema.js.map