"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    getInsurerPaymentsWithRemainingBalanceDisplay: function() {
        return getInsurerPaymentsWithRemainingBalanceDisplay;
    },
    getInvoiceInsurerPaymentStatus: function() {
        return getInvoiceInsurerPaymentStatus;
    },
    getInvoicePatientPaymentStatus: function() {
        return getInvoicePatientPaymentStatus;
    },
    getPatientPaymentsWithRemainingBalanceDisplay: function() {
        return getPatientPaymentsWithRemainingBalanceDisplay;
    },
    getSpecificInsurerPaymentRemainingBalance: function() {
        return getSpecificInsurerPaymentRemainingBalance;
    }
});
const _decimal = /*#__PURE__*/ _interop_require_default(require("decimal.js"));
const _constants = require("@tamanu/constants");
const _invoice = require("./invoice");
const _display = require("./display");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const getInvoicePatientPaymentStatus = (paidAmount, owingAmount)=>{
    paidAmount = (0, _display.round)(paidAmount, 2);
    owingAmount = (0, _display.round)(owingAmount, 2);
    if (paidAmount < 0) throw new Error('Paid amount cannot be negative');
    if (paidAmount > owingAmount) throw new Error('Paid amount cannot be greater than owing amount');
    if (paidAmount === 0) return _constants.INVOICE_PATIENT_PAYMENT_STATUSES.UNPAID;
    if (paidAmount === owingAmount) return _constants.INVOICE_PATIENT_PAYMENT_STATUSES.PAID;
    return _constants.INVOICE_PATIENT_PAYMENT_STATUSES.PARTIAL;
};
const getInvoiceInsurerPaymentStatus = (paidAmount, owingAmount)=>{
    if (paidAmount == null) return _constants.INVOICE_INSURER_PAYMENT_STATUSES.UNPAID;
    paidAmount = (0, _display.round)(paidAmount, 2);
    owingAmount = (0, _display.round)(owingAmount, 2);
    if (paidAmount < 0) throw new Error('Paid amount cannot be negative');
    if (paidAmount > owingAmount) throw new Error('Paid amount cannot be greater than owing amount');
    if (paidAmount === 0) return _constants.INVOICE_INSURER_PAYMENT_STATUSES.REJECTED;
    if (paidAmount === owingAmount) return _constants.INVOICE_INSURER_PAYMENT_STATUSES.PAID;
    return _constants.INVOICE_INSURER_PAYMENT_STATUSES.PARTIAL;
};
const getPatientPaymentsWithRemainingBalanceDisplay = (invoice)=>{
    const patientPayments = invoice.payments.filter((payment)=>payment?.patientPayment?.id);
    let { patientTotal } = (0, _invoice.getInvoiceSummary)(invoice);
    const patientPaymentsWithRemainingBalance = patientPayments?.map((payment)=>{
        patientTotal = new _decimal.default(patientTotal).minus(payment.amount).toNumber();
        return {
            ...payment,
            amount: (0, _display.formatDisplayPrice)(payment.amount),
            remainingBalance: (0, _display.formatDisplayPrice)(patientTotal)
        };
    });
    return patientPaymentsWithRemainingBalance;
};
const getInsurerPaymentsWithRemainingBalanceDisplay = (invoice)=>{
    const insurerPayments = invoice.payments.filter((payment)=>payment?.insurerPayment?.id);
    let { insuranceCoverageTotal } = (0, _invoice.getInvoiceSummary)(invoice);
    const insurerPaymentsWithRemainingBalance = insurerPayments?.map((payment)=>{
        insuranceCoverageTotal = new _decimal.default(insuranceCoverageTotal).minus(payment.amount).toNumber();
        return {
            ...payment,
            amount: (0, _display.formatDisplayPrice)(payment.amount),
            remainingBalance: (0, _display.formatDisplayPrice)(insuranceCoverageTotal)
        };
    });
    return insurerPaymentsWithRemainingBalance;
};
const getSpecificInsurerPaymentRemainingBalance = (insurers, payments, insurerId, total)=>{
    const insurersDiscountPercentage = insurers.filter((insurer)=>insurer.insurerId === insurerId).reduce((sum, insurer)=>sum.plus(insurer?.percentage || 0), new _decimal.default(0)).toNumber();
    const insurerDiscountTotal = new _decimal.default(total).times(insurersDiscountPercentage).toNumber();
    const insurerPaymentsTotal = payments.filter((payment)=>payment?.insurerPayment?.id && payment.insurerPayment.insurerId === insurerId).reduce((sum, payment)=>sum.plus(payment.amount), new _decimal.default(0)).toNumber();
    return {
        insurerDiscountTotal,
        insurerPaymentsTotal,
        insurerPaymentRemainingBalance: new _decimal.default(insurerDiscountTotal).minus(insurerPaymentsTotal).toNumber()
    };
};

//# sourceMappingURL=payments.js.map