/*
Returns the first Note (Sequelize model instance) with the specified noteTypeId, or undefined.

notes: Array<SequelizeModel>
noteTypeId: string (note type ID, e.g., 'notetype-other', 'notetype-system')
*/ "use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    getNoteWithType: function() {
        return getNoteWithType;
    },
    getNotesWithType: function() {
        return getNotesWithType;
    }
});
const getNoteWithType = (notes, noteTypeId)=>{
    return getNotesWithType(notes, noteTypeId)[0];
};
const getNotesWithType = (notes, noteTypeId)=>{
    return notes.filter((note)=>note.noteTypeId === noteTypeId);
};

//# sourceMappingURL=notes.js.map