"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "getReferenceDataCategoryFromRowConfig", {
    enumerable: true,
    get: function() {
        return getReferenceDataCategoryFromRowConfig;
    }
});
const _lodash = require("lodash");
const getReferenceDataCategoryFromRowConfig = (configString)=>{
    try {
        const config = JSON.parse(configString);
        // Special handling for icd10, which is the legacy code for diagnosis
        const type = config.where?.type === 'icd10' ? 'diagnosis' : config.where?.type;
        return (0, _lodash.camelCase)(config.source === 'ReferenceData' ? type : config.source);
    } catch (e) {
        return null;
    }
};

//# sourceMappingURL=getReferenceDataCategoryFromRowConfig.js.map