import React from 'react';
import { Document, StyleSheet, View } from '@react-pdf/renderer';
import { INTERIM_LAB_REQUEST_STATUSES } from '@tamanu/constants';
import { getReferenceRangeWithUnit } from '@tamanu/utils/labTests';
import { PatientDetails } from './printComponents/PatientDetails';
import { styles, CertificateHeader } from './Layout';
import { LetterheadSection } from './LetterheadSection';
import { EncounterDetails } from './printComponents/EncounterDetails';
import { MultiPageHeader } from './printComponents/MultiPageHeader';
import { Footer } from './printComponents/Footer';
import { useLanguageContext, withLanguageContext } from '../pdf/languageContext';
import { Page } from '../pdf/Page';
import { MinimalLabRequestDetailsSection, SampleDetailsRow, PublishedDetailsRow } from './LabRequestDetailsSection';
import { Table } from './Table';
import { P } from './Typography';
import { getName } from '../patientAccessors';
import { HorizontalRule } from './printComponents/HorizontalRule';
import { DoubleHorizontalRule } from './printComponents/DoubleHorizontalRule';
const generalStyles = StyleSheet.create({
    page: {
        paddingBottom: 50
    },
    container: {
        marginVertical: 6
    },
    interimBannerText: {
        border: '1px solid black',
        textAlign: 'center',
        padding: '8px',
        marginHorizontal: '18px'
    },
    tableContainer: {
        marginTop: 8
    },
    tableHeaderStyles: {
        paddingLeft: 6,
        paddingVertical: 8,
        fontSize: 9
    },
    tableColumnStyles: {
        paddingLeft: 6,
        paddingVertical: 4,
        fontSize: 9
    },
    detailsContainer: {
        marginBottom: 5
    },
    resultsInterpretationContainer: {
        border: '1px solid black',
        padding: 10,
        marginBottom: 10
    }
});
const SectionContainer = (props)=>/*#__PURE__*/ React.createElement(View, {
        style: generalStyles.container,
        ...props
    });
const LabRequestDetailsSection = ({ labRequest })=>{
    const { getTranslation } = useLanguageContext();
    return /*#__PURE__*/ React.createElement(View, {
        style: generalStyles.detailsContainer
    }, /*#__PURE__*/ React.createElement(P, {
        bold: true,
        fontSize: 11,
        mb: 3
    }, getTranslation('pdf.labResults.labRequestDetailsTitle', 'Lab request details')), /*#__PURE__*/ React.createElement(HorizontalRule, null), /*#__PURE__*/ React.createElement(MinimalLabRequestDetailsSection, {
        request: labRequest
    }), /*#__PURE__*/ React.createElement(HorizontalRule, null), /*#__PURE__*/ React.createElement(SampleDetailsRow, {
        request: labRequest
    }), /*#__PURE__*/ React.createElement(HorizontalRule, null), /*#__PURE__*/ React.createElement(PublishedDetailsRow, {
        request: labRequest
    }), /*#__PURE__*/ React.createElement(DoubleHorizontalRule, null));
};
const InterimBanner = ()=>{
    const { getTranslation } = useLanguageContext();
    return /*#__PURE__*/ React.createElement(P, {
        style: generalStyles.interimBannerText,
        fontSize: 14,
        bold: true
    }, getTranslation('pdf.labResults.interimBanner', 'This report contains interim results that have not yet been published'));
};
const LabResultsPrintoutComponent = /*#__PURE__*/ React.memo(({ patientData, encounter, labRequest, certificateData, getLocalisation, getSetting })=>{
    const { getTranslation } = useLanguageContext();
    const { logo } = certificateData;
    const { tests, labTestPanelRequest } = labRequest;
    const labResultsColumns = [
        {
            key: 'labTestType.name',
            title: getTranslation('lab.results.table.column.testType', 'Test'),
            accessor: ({ labTestType })=>labTestType?.name || ''
        },
        {
            key: 'result',
            title: getTranslation('lab.results.table.column.result', 'Result'),
            accessor: ({ result, labTestType })=>{
                if (result === undefined || result === null || result === '') return '';
                const unit = labTestType?.unit;
                return unit ? `${result} ${unit}` : result;
            }
        },
        {
            key: 'reference',
            title: getTranslation('lab.results.table.column.reference', 'Reference'),
            accessor: ({ labTestType })=>getReferenceRangeWithUnit({
                    labTestType,
                    sex: patientData?.sex,
                    getTranslation
                })
        }
    ];
    /**
     * Currently it is only possible for one panel request per results printout
     * To support multiple panels, we can ensure that rows with the same panel name are ordered together
     * and then use the following to get the groups section label:
     * @example
     * getRowSectionLabel = (row) => row.panelName;
     */ const getRowSectionLabel = ()=>labTestPanelRequest?.labTestPanel?.name;
    return /*#__PURE__*/ React.createElement(Document, null, /*#__PURE__*/ React.createElement(Page, {
        size: "A4",
        style: [
            styles.page,
            generalStyles.page
        ]
    }, tests?.length > 0 && /*#__PURE__*/ React.createElement(MultiPageHeader, {
        documentName: getTranslation('pdf.labResults.documentName', 'Lab results'),
        documentSubname: getTranslation('pdf.labResults.documentSubname', 'Request ID: :requestId', {
            replacements: {
                requestId: labRequest?.displayId || ''
            }
        }),
        patientId: patientData?.displayId || '',
        patientName: getName(patientData)
    }), /*#__PURE__*/ React.createElement(CertificateHeader, null, /*#__PURE__*/ React.createElement(LetterheadSection, {
        logoSrc: logo,
        letterheadConfig: certificateData,
        certificateTitle: getTranslation('pdf.labResults.documentName', 'Lab results')
    }), INTERIM_LAB_REQUEST_STATUSES.includes(labRequest.status) && /*#__PURE__*/ React.createElement(InterimBanner, null), /*#__PURE__*/ React.createElement(SectionContainer, null, /*#__PURE__*/ React.createElement(PatientDetails, {
        patient: patientData,
        getLocalisation: getLocalisation,
        getSetting: getSetting
    })), /*#__PURE__*/ React.createElement(SectionContainer, null, /*#__PURE__*/ React.createElement(EncounterDetails, {
        hideLocation: true,
        encounter: encounter
    }))), /*#__PURE__*/ React.createElement(SectionContainer, null, /*#__PURE__*/ React.createElement(LabRequestDetailsSection, {
        labRequest: labRequest
    })), tests?.length > 0 && /*#__PURE__*/ React.createElement(SectionContainer, null, /*#__PURE__*/ React.createElement(P, {
        bold: true,
        fontSize: 11,
        mb: 3
    }, getTranslation('pdf.labResults.testResultsTitle', 'Test results')), /*#__PURE__*/ React.createElement(View, {
        style: generalStyles.tableContainer
    }, /*#__PURE__*/ React.createElement(Table, {
        hideRowDividers: true,
        data: tests,
        columns: labResultsColumns,
        getLocalisation: getLocalisation,
        getSetting: getSetting,
        getRowSectionLabel: getRowSectionLabel,
        headerStyle: generalStyles.tableHeaderStyles,
        columnStyle: generalStyles.tableColumnStyles
    }))), labRequest.resultsInterpretation && /*#__PURE__*/ React.createElement(SectionContainer, null, /*#__PURE__*/ React.createElement(P, {
        bold: true,
        fontSize: 11,
        mb: 3
    }, getTranslation('pdf.labResults.resultsInterpretationTitle', 'Results interpretation')), /*#__PURE__*/ React.createElement(View, {
        style: generalStyles.resultsInterpretationContainer
    }, /*#__PURE__*/ React.createElement(P, {
        fontSize: 11
    }, labRequest.resultsInterpretation))), /*#__PURE__*/ React.createElement(Footer, null)));
});
export const LabResultsPrintout = withLanguageContext(LabResultsPrintoutComponent);

//# sourceMappingURL=LabResultsPrintout.js.map