import { Provider } from "@smithy/types";
export interface FlexibleChecksumsInputConfig {
    /**
     * Determines when a checksum will be calculated for request payloads.
     */
    requestChecksumCalculation?: string | Provider<string>;
    /**
     * Determines when checksum validation will be performed on response payloads.
     */
    responseChecksumValidation?: string | Provider<string>;
}
export interface FlexibleChecksumsResolvedConfig {
    requestChecksumCalculation: Provider<string>;
    responseChecksumValidation: Provider<string>;
}
export declare const resolveFlexibleChecksumsConfig: <T>(input: T & FlexibleChecksumsInputConfig) => T & FlexibleChecksumsResolvedConfig;
