"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    SYNC_DIRECTIONS: function() {
        return SYNC_DIRECTIONS;
    },
    SYNC_DIRECTIONS_VALUES: function() {
        return SYNC_DIRECTIONS_VALUES;
    },
    SYNC_STREAM_MESSAGE_KIND: function() {
        return SYNC_STREAM_MESSAGE_KIND;
    }
});
const SYNC_DIRECTIONS = {
    DO_NOT_SYNC: 'do_not_sync',
    PUSH_TO_CENTRAL: 'push_to_central',
    PUSH_TO_CENTRAL_THEN_DELETE: 'push_to_central_then_delete',
    PULL_FROM_CENTRAL: 'pull_from_central',
    BIDIRECTIONAL: 'bidirectional'
};
const SYNC_DIRECTIONS_VALUES = Object.values(SYNC_DIRECTIONS);
// 16-bit uint
//
// When adding message kinds here, also add them to the Wireshark dissector at:
// /docs/wireshark-tamanu-stream.lua
const NEVER_USE_ZERO = Symbol('zero');
const SYNC_STREAM_MESSAGE_KIND = {
    // This should never be used, so we make it impossible to
    [NEVER_USE_ZERO]: 0x0000,
    // Control messages start with 0xf
    END: 0xf001,
    // Application messages start with 0x0
    SESSION_WAITING: 0x0001,
    PULL_WAITING: 0x0002,
    PULL_CHANGE: 0x0003
};

//# sourceMappingURL=sync.js.map