"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    DEPARTMENTS: function() {
        return DEPARTMENTS;
    },
    seedDepartments: function() {
        return seedDepartments;
    }
});
const _utilities = require("./utilities");
const DEPARTMENTS = (0, _utilities.splitIds)(`
  Medical
  Renal
  Emergency
  Surgical
  Diabetes
  HIV
  Tuberculosis
  Paediatric
  Neonatal
  Antenatal
  Laboratory
  Radiology
  Pharmacy
`);
const seedDepartments = async (models)=>{
    const facilityId = await (0, _utilities.randomRecordId)(models, 'Facility');
    const departments = DEPARTMENTS.map((d)=>({
            ...d,
            code: d.name,
            facilityId
        }));
    return models.Department.bulkCreate(departments);
};

//# sourceMappingURL=departments.js.map