"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    await query.addColumn('administered_vaccines', 'giver_id', {
        type: _sequelize.STRING,
        allowNull: true,
        references: {
            model: 'users',
            key: 'id'
        }
    });
    await query.addColumn('administered_vaccines', 'recorder_id', {
        type: _sequelize.STRING,
        allowNull: true,
        references: {
            model: 'users',
            key: 'id'
        }
    });
    await query.sequelize.query(`
    UPDATE administered_vaccines
    SET recorder_id = encounters.examiner_id,
        giver_id    = encounters.examiner_id
    FROM encounters
    WHERE administered_vaccines.encounter_id = encounters.id
  `);
    await query.removeColumn('administered_vaccines', 'location');
    await query.addColumn('administered_vaccines', 'location_id', {
        type: _sequelize.STRING,
        allowNull: true,
        references: {
            model: 'locations',
            key: 'id'
        }
    });
    await query.addColumn('administered_vaccines', 'department_id', {
        type: _sequelize.STRING,
        allowNull: true,
        references: {
            model: 'departments',
            key: 'id'
        }
    });
}
async function down(query) {
    await query.removeColumn('administered_vaccines', 'department_id');
    await query.removeColumn('administered_vaccines', 'location_id');
    await query.removeColumn('administered_vaccines', 'recorder_id');
    await query.removeColumn('administered_vaccines', 'giver_id');
    await query.addColumn('administered_vaccines', 'location', {
        type: _sequelize.STRING,
        allowNull: true
    });
}

//# sourceMappingURL=075_addAdministeredVaccineMetadataFields.js.map