"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = /*#__PURE__*/ _interop_require_default(require("sequelize"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const commonColumns = {
    id: {
        type: _sequelize.default.STRING,
        allowNull: false,
        primaryKey: true,
        defaultValue: _sequelize.default.UUIDV4
    },
    created_at: {
        type: _sequelize.default.DATE,
        defaultValue: _sequelize.default.NOW,
        allowNull: false
    },
    updated_at: {
        type: _sequelize.default.DATE,
        defaultValue: _sequelize.default.NOW,
        allowNull: false
    },
    deleted_at: {
        type: _sequelize.default.DATE,
        allowNull: true
    },
    marked_for_push: {
        type: _sequelize.default.BOOLEAN,
        allowNull: false,
        defaultValue: true
    },
    is_pushing: {
        type: _sequelize.default.BOOLEAN,
        allowNull: false,
        defaultValue: false
    },
    pushed_at: {
        type: _sequelize.default.DATE,
        allowNull: true
    },
    pulled_at: {
        type: _sequelize.default.DATE,
        allowNull: true
    }
};
const tables = [
    [
        'patient_field_definition_categories',
        {
            ...commonColumns,
            name: {
                type: _sequelize.default.STRING,
                allowNull: false
            }
        }
    ],
    [
        'patient_field_definitions',
        {
            ...commonColumns,
            name: {
                type: _sequelize.default.STRING,
                allowNull: false
            },
            field_type: {
                type: _sequelize.default.STRING,
                allowNull: false
            },
            options: _sequelize.default.ARRAY(_sequelize.default.STRING),
            visibility_status: {
                type: _sequelize.default.STRING,
                allowNull: false,
                defaultValue: 'current'
            },
            category_id: {
                type: _sequelize.default.STRING,
                references: {
                    model: 'patient_field_definition_categories',
                    key: 'id'
                },
                allowNull: false
            }
        }
    ],
    [
        'patient_field_values',
        {
            ...commonColumns,
            value: {
                type: _sequelize.default.TEXT,
                allowNull: false
            },
            definition_id: {
                type: _sequelize.default.STRING,
                references: {
                    model: 'patient_field_definitions',
                    key: 'id'
                },
                allowNull: false
            },
            patient_id: {
                type: _sequelize.default.STRING,
                references: {
                    model: 'patients',
                    key: 'id'
                },
                allowNull: false
            }
        }
    ]
];
async function up(query) {
    for (const [name, def] of tables){
        await query.createTable(name, def);
    }
    await query.addIndex('patient_field_values', {
        name: 'patient_field_values_patient_id',
        fields: [
            'patient_id'
        ]
    });
    await query.addIndex('patient_field_values', {
        name: 'patient_field_values_definition_id',
        fields: [
            'definition_id'
        ]
    });
    await query.addIndex('patient_field_values', {
        name: 'patient_field_values_updated_at',
        fields: [
            'updated_at'
        ]
    });
}
async function down(query) {
    await query.removeIndex('patient_field_values', 'patient_field_values_updated_at');
    await query.removeIndex('patient_field_values', 'patient_field_values_definition_id');
    await query.removeIndex('patient_field_values', 'patient_field_values_patient_id');
    for (const [name] of tables.slice().reverse()){
        await query.dropTable(name);
    }
}

//# sourceMappingURL=117_addPatientFieldsTables.js.map