"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    await query.dropTable('channel_sync_pull_cursors');
}
async function down(query) {
    await query.createTable('channel_sync_pull_cursors', {
        id: {
            type: _sequelize.STRING,
            defaultValue: _sequelize.UUIDV4,
            allowNull: false,
            primaryKey: true
        },
        created_at: {
            type: _sequelize.DATE,
            defaultValue: _sequelize.NOW,
            allowNull: false
        },
        updated_at: {
            type: _sequelize.DATE,
            defaultValue: _sequelize.NOW,
            allowNull: false
        },
        deleted_at: {
            type: _sequelize.DATE,
            allowNull: true
        },
        channel: {
            type: _sequelize.STRING,
            allowNull: false
        },
        pull_cursor: {
            type: _sequelize.STRING,
            allowNull: true
        }
    });
}

//# sourceMappingURL=120_removeSyncCursorTable.js.map