"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    await query.createTable('imaging_area_external_codes', {
        id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            primaryKey: true,
            defaultValue: _sequelize.Sequelize.fn('uuid_generate_v4')
        },
        created_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.Sequelize.NOW,
            allowNull: false
        },
        updated_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.Sequelize.NOW,
            allowNull: false
        },
        deleted_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        },
        pulled_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        },
        visibility_status: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: false,
            defaultValue: 'current'
        },
        area_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            unique: true,
            references: {
                model: 'reference_data',
                key: 'id'
            }
        },
        code: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: false
        },
        description: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: true
        }
    });
}
async function down(query) {
    await query.dropTable('imaging_area_external_codes');
}

//# sourceMappingURL=1668649042720-imagingAreaExternalCodesTable.js.map