"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
const TABLE = {
    tableName: 'fhir_writes',
    schema: 'logs'
};
async function up(query) {
    await query.createSchema(TABLE.schema);
    await query.createTable(TABLE, {
        id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: false,
            primaryKey: true,
            defaultValue: _sequelize.Sequelize.fn('uuid_generate_v4')
        },
        created_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: false,
            defaultValue: _sequelize.Sequelize.fn('current_timestamp', 6)
        },
        verb: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: false
        },
        url: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: false
        },
        body: {
            type: _sequelize.DataTypes.JSONB,
            allowNull: false,
            defaultValue: {}
        },
        headers: {
            type: _sequelize.DataTypes.JSONB,
            allowNull: false,
            defaultValue: {}
        },
        user_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: true,
            references: {
                model: {
                    tableName: 'users',
                    schema: 'public'
                },
                key: 'id'
            }
        }
    });
    await query.addIndex(TABLE, {
        fields: [
            'headers'
        ],
        using: 'gin'
    });
    await query.addIndex(TABLE, {
        fields: [
            'url'
        ]
    });
    await query.addIndex(TABLE, {
        fields: [
            'verb'
        ]
    });
}
async function down(query) {
    await query.dropTable(TABLE);
    await query.dropSchema(TABLE.schema);
}

//# sourceMappingURL=1679999671335-fhirLogging.js.map