"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const TABLE = {
    schema: 'fhir',
    tableName: 'service_requests'
};
async function up(query) {
    await query.removeConstraint(TABLE, 'service_requests_imaging_request_id_fkey');
}
async function down(query) {
    await query.addConstraint(TABLE, {
        type: 'foreign key',
        name: 'service_requests_imaging_request_id_fkey',
        fields: [
            'upstream_id'
        ],
        references: {
            table: 'imaging_requests',
            field: 'id'
        }
    });
}

//# sourceMappingURL=1682638735334-removeConstraintFromServiceRequests.js.map