"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = /*#__PURE__*/ _interop_require_default(require("sequelize"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
async function up(query) {
    await query.createTable('user_preferences', {
        // User preference records use a user_id as the primary key, acting as a
        // db-level enforcement of one per user, and simplifying sync
        id: {
            type: 'TEXT GENERATED ALWAYS AS ("user_id") STORED'
        },
        created_at: {
            type: _sequelize.default.DATE,
            defaultValue: _sequelize.default.fn('now'),
            allowNull: false
        },
        updated_at: {
            type: _sequelize.default.DATE,
            defaultValue: _sequelize.default.fn('now'),
            allowNull: false
        },
        deleted_at: {
            type: _sequelize.default.DATE,
            allowNull: true
        },
        user_id: {
            type: _sequelize.default.STRING,
            references: {
                model: 'users',
                key: 'id'
            },
            primaryKey: true,
            onDelete: 'cascade',
            allowNull: false
        },
        selected_graphed_vitals_on_filter: {
            type: _sequelize.default.STRING,
            allowNull: true
        }
    });
    await query.addConstraint('user_preferences', {
        fields: [
            'user_id'
        ],
        type: 'unique'
    });
}
async function down(query) {
    await query.dropTable('user_preferences');
}

//# sourceMappingURL=1691037875375-addUserPreferencesTable.js.map