"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = /*#__PURE__*/ _interop_require_default(require("sequelize"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
async function up(query) {
    await query.createTable('ips_requests', {
        id: {
            type: _sequelize.default.STRING,
            defaultValue: _sequelize.default.fn('uuid_generate_v4'),
            allowNull: false,
            primaryKey: true
        },
        created_at: {
            type: _sequelize.default.DATE,
            defaultValue: _sequelize.default.fn('current_timestamp', 3),
            allowNull: false
        },
        updated_at: {
            type: _sequelize.default.DATE,
            defaultValue: _sequelize.default.NOW,
            allowNull: false
        },
        deleted_at: {
            type: _sequelize.default.DATE,
            allowNull: true
        },
        patient_id: {
            type: _sequelize.default.STRING,
            allowNull: false,
            references: {
                model: 'patients',
                key: 'id'
            }
        },
        created_by: {
            type: _sequelize.default.STRING,
            allowNull: false,
            references: {
                model: 'users',
                key: 'id'
            }
        },
        status: {
            type: _sequelize.default.STRING,
            allowNull: false
        },
        email: {
            type: _sequelize.default.STRING,
            allowNull: false
        }
    });
}
async function down(query) {
    await query.dropTable('ips_requests');
}

//# sourceMappingURL=1699831661035_addIPSRequestTable.js.map