"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    await query.addColumn('patient_allergies', 'reaction_id', {
        type: _sequelize.DataTypes.STRING,
        allowNull: true
    });
    await query.addConstraint('patient_allergies', {
        fields: [
            'reaction_id'
        ],
        type: 'foreign key',
        references: {
            table: 'reference_data',
            field: 'id'
        }
    });
}
async function down(query) {
    await query.removeColumn('patient_allergies', 'reaction_id');
}

//# sourceMappingURL=1711014042261-addReactionIdForPatientAllergies.js.map