/** @typedef {import('sequelize').QueryInterface} QueryInterface */ "use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _sequelize = require("sequelize");
const _selectFacilityIds = require("@tamanu/utils/selectFacilityIds");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const DEFAULT_SETTINGS = {
    'vaccinationReminder.due': JSON.stringify([
        7,
        1,
        -7
    ])
};
async function up(query) {
    const isFacilityServer = !!(0, _selectFacilityIds.selectFacilityIds)(_config.default);
    if (isFacilityServer) return;
    await query.bulkInsert('settings', Object.entries(DEFAULT_SETTINGS).map(([key, value])=>({
            key,
            value
        })));
}
async function down(query) {
    const isFacilityServer = !!(0, _selectFacilityIds.selectFacilityIds)(_config.default);
    if (isFacilityServer) return;
    await query.bulkDelete('settings', {
        key: {
            [_sequelize.Op.in]: Object.keys(DEFAULT_SETTINGS)
        }
    });
}

//# sourceMappingURL=1712995058569-addVaccinationReminderDueSetting.js.map