/** @typedef {import('sequelize').QueryInterface} QueryInterface */ "use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    await query.addColumn('patient_death_data', `antecedent_cause3_time_after_onset`, {
        type: _sequelize.INTEGER,
        allowNull: true,
        defaultValue: null
    });
    await query.addColumn('patient_death_data', `antecedent_cause3_condition_id`, {
        type: _sequelize.STRING,
        allowNull: true,
        references: {
            model: 'reference_data',
            key: 'id'
        }
    });
}
async function down(query) {
    await query.removeColumn('patient_death_data', `antecedent_cause3_condition_id`);
    await query.removeColumn('patient_death_data', `antecedent_cause3_time_after_onset`);
}

//# sourceMappingURL=1713777929517-add4thCauseOfDeath.js.map