"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    // Step 1: Add new columns
    await query.addColumn('patient_program_registrations', 'deactivated_clinician_id', {
        type: _sequelize.DataTypes.STRING,
        allowNull: true,
        references: {
            model: 'users',
            key: 'id'
        }
    });
    await query.addColumn('patient_program_registrations', 'deactivated_date', {
        type: _sequelize.DataTypes.STRING,
        allowNull: true
    });
    // Step 2: Update deactivation fields for inactive most recent registrations
    await query.sequelize.query(`
    UPDATE patient_program_registrations current
    SET
      deactivated_date = current.date,
      deactivated_clinician_id = current.clinician_id
    WHERE
      registration_status = 'inactive'
      AND is_most_recent = TRUE;
  `);
    // Step 3: Update date and clinician_id to earliest registration for inactive registrations
    await query.sequelize.query(`
    WITH earliest_registrations AS (
      SELECT DISTINCT ON (patient_id, program_registry_id)
        id,
        date,
        clinician_id,
        patient_id,
        program_registry_id
      FROM patient_program_registrations
      ORDER BY
        patient_id,
        program_registry_id,
        date ASC
    )
    UPDATE patient_program_registrations current
    SET
      date = er.date,
      clinician_id = er.clinician_id
    FROM earliest_registrations er
    WHERE
      current.patient_id = er.patient_id
      AND current.program_registry_id = er.program_registry_id
      AND current.registration_status = 'inactive'
      AND is_most_recent = TRUE;
  `);
}
async function down(query) {
    await query.removeColumn('patient_program_registrations', 'deactivated_clinician_id');
    await query.removeColumn('patient_program_registrations', 'deactivated_date');
}

//# sourceMappingURL=1744234388449-addPatientProgramRegistrationInactiveFields.js.map