"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const makeNoteTypeId = (noteType)=>`notetype-${noteType}`;
async function up(query) {
    const existingTranslations = await query.sequelize.query(`SELECT string_id, language, text FROM translated_strings WHERE string_id ILIKE 'note.property.type%'`, {
        type: _sequelize.QueryTypes.SELECT
    });
    const translationsToInsert = [];
    if (existingTranslations.length > 0) {
        const migratedTranslations = existingTranslations.map((translation)=>{
            // Replace to get noteType, e.g. 'note.property.type.treatmentPlan' -> 'treatmentPlan'
            const noteType = translation.string_id.replace(`note.property.type.`, '');
            // Create string_id for the new translation, e.g. 'refData.noteType.notetype-treatmentPlan'
            const newStringId = `${_constants.REFERENCE_DATA_TRANSLATION_PREFIX}.${_constants.REFERENCE_TYPES.NOTE_TYPE}.${makeNoteTypeId(noteType)}`;
            return {
                string_id: newStringId,
                language: translation.language,
                text: translation.text
            };
        }).filter(Boolean);
        translationsToInsert.push(...migratedTranslations);
    }
    if (translationsToInsert.length > 0) {
        for (const translation of translationsToInsert){
            await query.sequelize.query(`
        INSERT INTO translated_strings (string_id, language, text)
        VALUES (:string_id, :language, :text)
        ON CONFLICT (string_id, language) DO UPDATE SET
          text = EXCLUDED.text
        `, {
                replacements: {
                    string_id: translation.string_id,
                    language: translation.language,
                    text: translation.text
                }
            });
        }
    }
}
async function down(query) {
    await query.sequelize.query(`DELETE FROM translated_strings WHERE string_id ILIKE '${_constants.REFERENCE_DATA_TRANSLATION_PREFIX}.${_constants.REFERENCE_TYPES.NOTE_TYPE}%'`);
}

//# sourceMappingURL=1759898295414-migrateNoteTypeTranslations.js.map