"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    await query.addColumn('pharmacy_orders', 'date', {
        type: _sequelize.DataTypes.DATETIMESTRING,
        allowNull: true
    });
    await query.addColumn('pharmacy_orders', 'facility_id', {
        type: _sequelize.DataTypes.STRING,
        allowNull: true,
        references: {
            model: 'facilities',
            key: 'id'
        }
    });
}
async function down(query) {
    await query.removeColumn('pharmacy_orders', 'facility_id');
    await query.removeColumn('pharmacy_orders', 'date');
}

//# sourceMappingURL=1764976539675-addDateAndFacilityIdToPharmacyOrders.js.map