import { Model } from './Model';
import { buildNoteLinkedSyncFilter } from '../sync/buildNoteLinkedSyncFilter';
import { type InitOptions, type Models } from '../types/model';
export declare class Note extends Model {
    id: string;
    noteTypeId: string;
    recordType: string;
    date: string;
    content: string;
    visibilityStatus: string;
    authorId?: string;
    onBehalfOfId?: string;
    revisedById?: string;
    static initModel({ primaryKey, ...options }: InitOptions): void;
    static initRelations(models: Models): void;
    static createForRecord(recordId: string, recordType: string, noteTypeId: string, content: string, authorId: string): Promise<Note>;
    getParentRecord(options: any): Promise<any>;
    static buildSyncLookupQueryDetails(): Promise<{
        select: string;
        joins: string;
    }>;
    static buildPatientSyncFilter: typeof buildNoteLinkedSyncFilter;
}
//# sourceMappingURL=Note.d.ts.map