"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "PatientDeathData", {
    enumerable: true,
    get: function() {
        return PatientDeathData;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _errors = require("@tamanu/errors");
const _Model = require("./Model");
const _buildPatientSyncFilterViaPatientId = require("../sync/buildPatientSyncFilterViaPatientId");
const _buildPatientLinkedLookupFilter = require("../sync/buildPatientLinkedLookupFilter");
const _model = require("../types/model");
function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
let PatientDeathData = class PatientDeathData extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            birthWeight: {
                type: _sequelize.DataTypes.INTEGER,
                unsigned: true
            },
            carrierAge: {
                type: _sequelize.DataTypes.INTEGER,
                unsigned: true
            },
            carrierPregnancyWeeks: {
                type: _sequelize.DataTypes.INTEGER,
                unsigned: true
            },
            externalCauseDate: (0, _model.dateType)('externalCauseDate'),
            lastSurgeryDate: (0, _model.dateType)('lastSurgeryDate'),
            externalCauseLocation: _sequelize.DataTypes.STRING,
            externalCauseNotes: _sequelize.DataTypes.TEXT,
            fetalOrInfant: _sequelize.DataTypes.BOOLEAN,
            hoursSurvivedSinceBirth: {
                type: _sequelize.DataTypes.INTEGER,
                unsigned: true
            },
            manner: _sequelize.DataTypes.STRING,
            pregnancyContributed: _sequelize.DataTypes.STRING,
            recentSurgery: _sequelize.DataTypes.STRING,
            stillborn: _sequelize.DataTypes.STRING,
            wasPregnant: _sequelize.DataTypes.STRING,
            withinDayOfBirth: _sequelize.DataTypes.BOOLEAN,
            outsideHealthFacility: _sequelize.DataTypes.BOOLEAN,
            primaryCauseTimeAfterOnset: _sequelize.DataTypes.INTEGER,
            antecedentCause1TimeAfterOnset: _sequelize.DataTypes.INTEGER,
            antecedentCause2TimeAfterOnset: _sequelize.DataTypes.INTEGER,
            antecedentCause3TimeAfterOnset: _sequelize.DataTypes.INTEGER,
            isFinal: _sequelize.DataTypes.BOOLEAN,
            visibilityStatus: {
                type: _sequelize.DataTypes.TEXT,
                defaultValue: _constants.VISIBILITY_STATUSES.CURRENT
            }
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL,
            tableName: 'patient_death_data',
            validate: {
                mustHavePatient () {
                    if (this.deletedAt) return;
                    if (!this.patientId) {
                        throw new _errors.InvalidOperationError('Patient death data must have a patient.');
                    }
                },
                mustHaveClinician () {
                    if (this.deletedAt) return;
                    if (!this.clinicianId) {
                        throw new _errors.InvalidOperationError('Patient death data must have a clinician.');
                    }
                },
                yesNoUnknownFields () {
                    if (this.deletedAt) return;
                    for (const field of [
                        'recentSurgery',
                        'wasPregnant',
                        'pregnancyContributed',
                        'stillborn'
                    ]){
                        if (this[field] && ![
                            'yes',
                            'no',
                            'unknown'
                        ].includes(this[field])) {
                            throw new _errors.InvalidOperationError(`${field} must be 'yes', 'no', 'unknown', or null`);
                        }
                    }
                }
            }
        });
    }
    static initRelations(models) {
        this.belongsTo(models.Patient, {
            foreignKey: 'patientId'
        });
        this.belongsTo(models.User, {
            foreignKey: 'clinicianId',
            as: 'clinician'
        });
        this.belongsTo(models.Facility, {
            foreignKey: 'facilityId',
            as: 'facility'
        });
        // conceptually "hasOne" but we want the foreign key to be here
        this.belongsTo(models.ReferenceData, {
            foreignKey: 'primaryCauseConditionId',
            as: 'primaryCauseCondition'
        });
        this.belongsTo(models.ReferenceData, {
            foreignKey: 'antecedentCause1ConditionId',
            as: 'antecedentCause1Condition'
        });
        this.belongsTo(models.ReferenceData, {
            foreignKey: 'antecedentCause2ConditionId',
            as: 'antecedentCause2Condition'
        });
        this.belongsTo(models.ReferenceData, {
            foreignKey: 'antecedentCause3ConditionId',
            as: 'antecedentCause3Condition'
        });
        this.belongsTo(models.ReferenceData, {
            foreignKey: 'lastSurgeryReasonId',
            as: 'lastSurgeryReason'
        });
        this.belongsTo(models.ReferenceData, {
            foreignKey: 'carrierExistingConditionId',
            as: 'carrierExistingCondition'
        });
        this.hasMany(models.ContributingDeathCause, {
            foreignKey: 'patientDeathDataId',
            as: 'contributingCauses'
        });
    }
    static async buildSyncLookupQueryDetails() {
        return (0, _buildPatientLinkedLookupFilter.buildPatientLinkedLookupFilter)(this);
    }
};
_define_property(PatientDeathData, "buildPatientSyncFilter", _buildPatientSyncFilterViaPatientId.buildPatientSyncFilterViaPatientId);

//# sourceMappingURL=PatientDeathData.js.map