"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "Permission", {
    enumerable: true,
    get: function() {
        return Permission;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
let Permission = class Permission extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            verb: {
                type: _sequelize.DataTypes.STRING,
                allowNull: false
            },
            noun: {
                type: _sequelize.DataTypes.STRING,
                allowNull: false
            },
            objectId: _sequelize.DataTypes.STRING
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.PULL_FROM_CENTRAL,
            // creating partial indexes as objectId can be null
            indexes: [
                {
                    name: 'permissions_role_id_noun_verb',
                    unique: true,
                    fields: [
                        'role_id',
                        'noun',
                        'verb'
                    ],
                    where: {
                        object_id: {
                            [_sequelize.Op.eq]: null
                        }
                    }
                },
                {
                    name: 'permissions_role_id_noun_verb_object_id',
                    unique: true,
                    fields: [
                        'role_id',
                        'noun',
                        'verb',
                        'object_id'
                    ],
                    where: {
                        object_id: {
                            [_sequelize.Op.ne]: null
                        }
                    }
                }
            ]
        });
    }
    static initRelations(models) {
        this.belongsTo(models.Role, {
            as: 'role',
            foreignKey: 'roleId'
        });
    }
    forResponse() {
        const { noun, verb, objectId } = this.dataValues;
        return {
            verb,
            noun,
            ...objectId ? {
                objectId
            } : undefined
        };
    }
    static buildSyncFilter() {
        return null; // syncs everywhere
    }
    static async buildSyncLookupQueryDetails() {
        return null; // syncs everywhere
    }
};

//# sourceMappingURL=Permission.js.map