import { Model } from './Model';
import type { InitOptions, Models } from '../types/model';
import type { MedicationDispense } from './MedicationDispense';
import type { PharmacyOrder } from './PharmacyOrder';
export declare class PharmacyOrderPrescription extends Model {
    id: string;
    pharmacyOrderId: string;
    prescriptionId: string;
    ongoingPrescriptionId?: string | null;
    displayId: string;
    quantity?: number;
    repeats?: number;
    isCompleted: boolean;
    medicationDispenses?: MedicationDispense[];
    pharmacyOrder?: PharmacyOrder;
    static initModel({ primaryKey, ...options }: InitOptions, models: Models): void;
    static initRelations(models: Models): void;
    getRemainingRepeats(extraDispenses?: number): number;
    static getListReferenceAssociations(): string[];
    static buildPatientSyncFilter(patientCount: number, markedForSyncPatientsTable: string): string | null;
    static buildSyncLookupQueryDetails(): Promise<{
        select: string;
        joins: string;
    }>;
}
//# sourceMappingURL=PharmacyOrderPrescription.d.ts.map