"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "FhirMedicationRequest", {
    enumerable: true,
    get: function() {
        return FhirMedicationRequest;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Resource = require("./Resource");
const _models = require("../../models");
const _MedicationRequest = require("../../utils/fhir/MedicationRequest");
function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
let FhirMedicationRequest = class FhirMedicationRequest extends _Resource.FhirResource {
    static initModel(options, models) {
        super.initResource({
            identifier: _sequelize.DataTypes.JSONB,
            status: {
                type: _sequelize.DataTypes.TEXT,
                allowNull: false
            },
            intent: {
                type: _sequelize.DataTypes.TEXT,
                allowNull: false
            },
            groupIdentifier: _sequelize.DataTypes.JSONB,
            category: _sequelize.DataTypes.JSONB,
            subject: _sequelize.DataTypes.JSONB,
            encounter: _sequelize.DataTypes.JSONB,
            medication: _sequelize.DataTypes.JSONB,
            authoredOn: _sequelize.DataTypes.DATE,
            requester: _sequelize.DataTypes.JSONB,
            recorder: _sequelize.DataTypes.JSONB,
            note: _sequelize.DataTypes.JSONB,
            dosageInstruction: _sequelize.DataTypes.JSONB,
            dispenseRequest: _sequelize.DataTypes.JSONB
        }, options);
        this.UpstreamModels = [
            models.PharmacyOrderPrescription
        ];
        this.upstreams = [
            models.PharmacyOrderPrescription,
            models.PharmacyOrder,
            models.Prescription,
            models.Encounter,
            models.Patient,
            models.User,
            models.ReferenceData,
            models.Facility
        ];
        this.referencedResources = [
            models.FhirPatient,
            models.FhirOrganization,
            models.FhirEncounter,
            models.FhirPractitioner
        ];
    }
    async updateMaterialisation() {
        const upstream = await this.getUpstream();
        if (!upstream) {
            throw new Error(`No upstream pharmacy_order_prescription found for medication_request: ${this.id}`);
        }
        const values = await (0, _MedicationRequest.getValues)(upstream, this.sequelize.models);
        this.set(values);
    }
    static async queryToFindUpstreamIdsFromTable(upstreamTable, table, id) {
        if (upstreamTable === _models.PharmacyOrderPrescription.tableName) {
            return (0, _MedicationRequest.getQueryToFindUpstreamIds)(this.sequelize.models, table, id);
        }
        return null;
    }
    static searchParameters() {
        return {
            ...super.searchParameters(),
            ..._MedicationRequest.searchParameters
        };
    }
};
_define_property(FhirMedicationRequest, "CAN_DO", new Set([
    _constants.FHIR_INTERACTIONS.INSTANCE.READ,
    _constants.FHIR_INTERACTIONS.TYPE.SEARCH,
    _constants.FHIR_INTERACTIONS.INTERNAL.MATERIALISE
]));

//# sourceMappingURL=FhirMedicationRequest.js.map