"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "FhirSpecimen", {
    enumerable: true,
    get: function() {
        return FhirSpecimen;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Resource = require("./Resource");
const _Specimen = require("../../utils/fhir/Specimen");
function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
let FhirSpecimen = class FhirSpecimen extends _Resource.FhirResource {
    static initModel(options, models) {
        super.initResource({
            collection: _sequelize.DataTypes.JSONB,
            request: _sequelize.DataTypes.JSONB,
            type: _sequelize.DataTypes.JSONB
        }, options);
        this.UpstreamModels = [
            models.LabRequest
        ];
        this.upstreams = [
            models.LabRequest
        ];
        this.referencedResources = [
            models.FhirPractitioner
        ];
    }
    async updateMaterialisation() {
        const upstream = await this.getUpstream((0, _Specimen.getQueryOptions)());
        const values = await (0, _Specimen.getValues)(upstream, this.sequelize.models);
        this.set(values);
    }
    static async queryToFindUpstreamIdsFromTable(upstreamTable, table, id) {
        const { LabRequest } = this.sequelize.models;
        if (upstreamTable === LabRequest.tableName) {
            return (0, _Specimen.fromLabRequest)(this.sequelize.models, table, id);
        }
        return null;
    }
    static async queryToFilterUpstream(upstreamTable) {
        const { LabRequest } = this.sequelize.models;
        if (upstreamTable === LabRequest.tableName) {
            return (0, _Specimen.filterFromLabRequests)(this.sequelize.models, upstreamTable);
        }
        return null;
    }
    static searchParameters() {
        return {
            ...super.searchParameters(),
            ..._Specimen.searchParameters
        };
    }
};
_define_property(FhirSpecimen, "CAN_DO", new Set([
    _constants.FHIR_INTERACTIONS.INSTANCE.READ,
    _constants.FHIR_INTERACTIONS.TYPE.SEARCH,
    _constants.FHIR_INTERACTIONS.INTERNAL.MATERIALISE
]));

//# sourceMappingURL=FhirSpecimen.js.map