"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "extractChangelogFromSnapshotRecords", {
    enumerable: true,
    get: function() {
        return extractChangelogFromSnapshotRecords;
    }
});
const extractChangelogFromSnapshotRecords = (snapshotRecordsWithChangelog)=>{
    const changelogRecords = [];
    const processedRecords = snapshotRecordsWithChangelog.reduce((acc, row)=>{
        if (row.changelogRecords) {
            changelogRecords.push(...row.changelogRecords);
            delete row.changelogRecords;
        }
        acc.push(row);
        return acc;
    }, []);
    return {
        snapshotRecords: processedRecords,
        changelogRecords
    };
};

//# sourceMappingURL=extractChangelogFromSnapshotRecords.js.map