import { Model } from './Model';
import { type InitOptions, type Models } from '../types/model';
declare const AVPU_VALUES: string[];
export declare class Vitals extends Model {
    id: string;
    dateRecorded: string;
    temperature?: number;
    weight?: number;
    height?: number;
    sbp?: number;
    dbp?: number;
    heartRate?: number;
    respiratoryRate?: number;
    spo2?: number;
    avpu?: (typeof AVPU_VALUES)[number];
    gcs?: number;
    hemoglobin?: number;
    fastingBloodGlucose?: number;
    urinePh?: number;
    urineLeukocytes?: string;
    urineNitrites?: string;
    urobilinogen?: number;
    urineProtein?: string;
    bloodInUrine?: string;
    urineSpecificGravity?: number;
    urineKetone?: string;
    urineBilirubin?: string;
    urineGlucose?: number;
    encounterId?: string;
    static initModel({ primaryKey, ...options }: InitOptions): void;
    static initRelations(models: Models): void;
    static buildPatientSyncFilter(patientCount: number, markedForSyncPatientsTable: string): string | null;
    static buildSyncLookupQueryDetails(): Promise<{
        select: string;
        joins: string;
    }>;
}
export {};
//# sourceMappingURL=Vitals.d.ts.map