"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "ApplicationContext", {
    enumerable: true,
    get: function() {
        return ApplicationContext;
    }
});
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _lodash = require("lodash");
const _logging = require("@tamanu/shared/services/logging");
const _reader = require("@tamanu/settings/reader");
const _selectFacilityIds = require("@tamanu/utils/selectFacilityIds");
const _database = require("./database");
const _versionCompatibility = require("./middleware/versionCompatibility.js");
function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
let ApplicationContext = class ApplicationContext {
    async init({ appType, databaseOverrides } = {}) {
        if (_config.default.errors?.enabled) {
            if (_config.default.errors.type === 'bugsnag') {
                await (0, _logging.initBugsnag)({
                    ...(0, _lodash.omit)(_config.default.errors, [
                        'enabled',
                        'type'
                    ]),
                    appVersion: [
                        _versionCompatibility.VERSION,
                        process.env.REVISION
                    ].filter(Boolean).join('-'),
                    appType
                });
            }
        }
        const facilityIds = (0, _selectFacilityIds.selectFacilityIds)(_config.default);
        const database = await (0, _database.initDatabase)(databaseOverrides);
        this.sequelize = database.sequelize;
        this.models = database.models;
        this.settings = facilityIds.reduce((acc, facilityId)=>{
            acc[facilityId] = new _reader.ReadSettings(this.models, facilityId);
            return acc;
        }, {});
        this.settings.global = new _reader.ReadSettings(this.models);
        if (_config.default.db.reportSchemas?.enabled) {
            this.reportSchemaStores = await (0, _database.initReporting)();
        }
        return this;
    }
    onClose(hook) {
        this.closeHooks.push(hook);
    }
    async close() {
        for (const hook of this.closeHooks){
            await hook();
        }
        await (0, _database.closeDatabase)();
    }
    constructor(){
        /** @type {Sequelize | null} */ _define_property(this, "sequelize", null);
        /** @type {Models | null} */ _define_property(this, "models", null);
        /**
   * @type {ReadSettings<FacilitySettingPath> | null}
   */ _define_property(this, "settings", null);
        _define_property(this, "reportSchemaStores", null);
        _define_property(this, "closeHooks", []);
    }
};

//# sourceMappingURL=ApplicationContext.js.map