"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "attachment", {
    enumerable: true,
    get: function() {
        return attachment;
    }
});
const _express = /*#__PURE__*/ _interop_require_default(require("express"));
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _yup = /*#__PURE__*/ _interop_require_wildcard(require("yup"));
const _sync = require("../../sync");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
const SAFE_ID_REGEX = /^[A-Za-z0-9-]+$/;
const ID_SCHEMA = _yup.string().matches(SAFE_ID_REGEX, 'id must not have spaces or punctuation other than -');
const attachment = _express.default.Router();
attachment.get('/:id', (0, _expressasynchandler.default)(async (req, res)=>{
    req.checkPermission('read', 'Attachment');
    const { query, params, deviceId } = req;
    const base64 = await _yup.boolean().default(false).validate(query?.base64);
    const id = await ID_SCHEMA.required().validate(params.id);
    const localAttachment = await req.models.Attachment.findByPk(id);
    if (localAttachment) {
        if (base64) {
            res.send({
                data: Buffer.from(localAttachment.data).toString('base64')
            });
        } else {
            res.setHeader('Content-Type', localAttachment.type);
            res.setHeader('Content-Length', localAttachment.size);
            res.send(Buffer.from(localAttachment.data));
        }
        return;
    }
    const centralServer = new _sync.CentralServerConnection({
        deviceId
    });
    const response = await centralServer.fetch(`attachment/${encodeURIComponent(id)}?base64=${base64}`, {
        method: 'GET',
        backoff: {
            maxAttempts: 5,
            maxWaitMs: 1000
        }
    });
    res.send(response);
}));

//# sourceMappingURL=attachment.js.map