"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "reportCommand", {
    enumerable: true,
    get: function() {
        return reportCommand;
    }
});
const _commander = require("commander");
const _logging = require("@tamanu/shared/services/logging");
const _ApplicationContext = require("../ApplicationContext");
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
async function report({ reportId }) {
    const context = await new _ApplicationContext.ApplicationContext().init({
        appType: 'report'
    });
    // going via inline import rather than top-level just to keep diff footprint small during a hotfix
    // should be fine to pull to the top level
    const { getReportModule } = await Promise.resolve().then(()=>/*#__PURE__*/ _interop_require_wildcard(require("@tamanu/shared/reports")));
    const module = await getReportModule(reportId, context.models);
    _logging.log.info(`Running report ${reportId} (with empty parameters)`);
    const result = await module.dataGenerator(context, {});
    // console.log is fine because this command should return output
    // eslint-disable-next-line no-console
    console.log(result);
    process.exit(0);
}
const reportCommand = new _commander.Command('report').description('Generate a report').requiredOption('--reportId <string>', 'Id of the report').action(report);

//# sourceMappingURL=report.js.map