"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    escapePatternWildcard: function() {
        return escapePatternWildcard;
    },
    getWhereClausesAndReplacementsFromFilters: function() {
        return getWhereClausesAndReplacementsFromFilters;
    },
    makeDeletedAtIsNullFilter: function() {
        return makeDeletedAtIsNullFilter;
    },
    makeFilter: function() {
        return makeFilter;
    },
    makeSimpleTextFilterFactory: function() {
        return makeSimpleTextFilterFactory;
    },
    makeSubstringTextFilterFactory: function() {
        return makeSubstringTextFilterFactory;
    }
});
const makeFilter = (check, sql, transform)=>{
    if (!check) return null;
    return {
        sql,
        transform
    };
};
const makeSimpleTextFilterFactory = (params)=>(paramKey, sqlField)=>{
        if (!params[paramKey]) return null;
        return {
            sql: `UPPER(${sqlField}) LIKE UPPER(:${paramKey})`,
            transform: (p)=>({
                    [paramKey]: `${p[paramKey]}%`
                })
        };
    };
const makeSubstringTextFilterFactory = (params)=>(paramKey, sqlField)=>{
        if (!params[paramKey]) return null;
        return {
            sql: `UPPER(${sqlField}) LIKE UPPER(:${paramKey})`,
            transform: (p)=>({
                    [paramKey]: `%${p[paramKey]}%`
                })
        };
    };
const makeDeletedAtIsNullFilter = (table)=>{
    if (!table) return null;
    return makeFilter(true, `${table}.deleted_at IS NULL`, ()=>({}));
};
// Escape wildcard characters _, % and backslash in pattern match
const wildcardRegex = /([_%\\])/g;
const escapePatternWildcard = (value)=>{
    return value.replace(wildcardRegex, '\\$1');
};
const getWhereClausesAndReplacementsFromFilters = (allFilters, params = {})=>{
    const filters = allFilters.filter((f)=>f);
    const whereClauses = filters.map((f)=>f.sql).join(' AND ');
    const filterReplacements = filters.filter((f)=>f.transform).reduce((current, { transform })=>({
            ...current,
            ...transform(current)
        }), params);
    return {
        whereClauses,
        filterReplacements
    };
};

//# sourceMappingURL=query.js.map