"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "validate", {
    enumerable: true,
    get: function() {
        return validate;
    }
});
const _zod = require("zod");
const _log = require("@tamanu/shared/services/logging/log");
const validate = (schema, body)=>{
    const validationResult = schema.safeParse(body);
    if (!validationResult.success) {
        // We just want to log errors at the moment
        const prettyError = _zod.z.prettifyError(validationResult.error);
        _log.log.error(`Validation failed: ${prettyError}`);
    }
    return validationResult.success ? validationResult.data : body;
};

//# sourceMappingURL=validate.js.map