"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "createInvoice", {
    enumerable: true,
    get: function() {
        return createInvoice;
    }
});
const _lodash = require("lodash");
const _utilities = require("@tamanu/database/demoData/utilities");
const _index = require("../../fake/index.js");
const createInvoice = async ({ models, limit, encounterId, userId, referenceDataId, productId, itemCount = _index.chance.integer({
    min: 1,
    max: 50
}) })=>{
    const { Invoice, InvoiceDiscount, InvoicePayment, InvoiceInsurerPayment, InvoicePatientPayment, InvoiceItemDiscount, InvoiceItem } = models;
    const invoice = await Invoice.create((0, _index.fake)(Invoice, {
        encounterId: encounterId || await (0, _utilities.randomRecordId)(models, 'Encounter')
    }));
    await InvoiceDiscount.create((0, _index.fake)(InvoiceDiscount, {
        invoiceId: invoice.id,
        appliedByUserId: userId || await (0, _utilities.randomRecordId)(models, 'User')
    }));
    await Promise.all((0, _lodash.times)(itemCount, ()=>limit(async ()=>{
            const invoiceItem = await InvoiceItem.create((0, _index.fake)(InvoiceItem, {
                invoiceId: invoice.id,
                productId: productId || await (0, _utilities.randomRecordId)(models, 'InvoiceProduct'),
                orderedByUserId: userId || await (0, _utilities.randomRecordId)(models, 'User')
            }));
            await InvoiceItemDiscount.create((0, _index.fake)(InvoiceItemDiscount, {
                invoiceItemId: invoiceItem.id
            }));
        })));
    const invoicePayment = await InvoicePayment.create((0, _index.fake)(InvoicePayment, {
        invoiceId: invoice.id
    }));
    await InvoiceInsurerPayment.create((0, _index.fake)(InvoiceInsurerPayment, {
        invoicePaymentId: invoicePayment.id,
        insurerId: referenceDataId || await (0, _utilities.randomRecordId)(models, 'ReferenceData')
    }));
    await InvoicePatientPayment.create((0, _index.fake)(InvoicePatientPayment, {
        invoicePaymentId: invoicePayment.id,
        methodId: referenceDataId || await (0, _utilities.randomRecordId)(models, 'ReferenceData')
    }));
};

//# sourceMappingURL=invoice.js.map