"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "OngoingPrescriptionSchema", {
    enumerable: true,
    get: function() {
        return OngoingPrescriptionSchema;
    }
});
const _zod = require("zod");
const _userschema = require("./user.schema");
const _referenceDataschema = require("./referenceData.schema");
const OngoingPrescriptionSchema = _zod.z.object({
    id: _zod.z.string(),
    medication: _referenceDataschema.ReferenceDataSchema,
    // Dose fields
    doseAmount: _zod.z.coerce.number().nullish(),
    units: _zod.z.string().nullish(),
    // Frequency and duration
    frequency: _zod.z.string().nullish(),
    durationValue: _zod.z.coerce.number().nullish(),
    durationUnit: _zod.z.string().nullish(),
    // Route and dates
    route: _zod.z.string().nullish(),
    startDate: _zod.z.string().nullish(),
    endDate: _zod.z.string().nullish(),
    // Prescriber information
    prescriber: _userschema.UserSchema.nullish(),
    // Status flags
    isOngoing: _zod.z.boolean().nullish(),
    isPrn: _zod.z.boolean().nullish(),
    isVariableDose: _zod.z.boolean().nullish(),
    discontinued: _zod.z.boolean().nullish(),
    discontinuedDate: _zod.z.string().nullish(),
    discontinuingReason: _zod.z.string().nullish(),
    // Additional information
    notes: _zod.z.string().nullish(),
    indication: _zod.z.string().nullish(),
    repeats: _zod.z.number().nullish(),
    quantity: _zod.z.number().nullish()
});

//# sourceMappingURL=ongoingPrescription.schema.js.map