"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "ProcedureSchema", {
    enumerable: true,
    get: function() {
        return ProcedureSchema;
    }
});
const _zod = require("zod");
const _userschema = require("./user.schema");
const _referenceDataschema = require("./referenceData.schema");
const ProcedureSchema = _zod.z.object({
    id: _zod.z.string(),
    completed: _zod.z.boolean(),
    date: _zod.z.string(),
    endTime: _zod.z.string().nullish(),
    startTime: _zod.z.string().nullish(),
    note: _zod.z.string().nullish(),
    completedNote: _zod.z.string().nullish(),
    encounterId: _zod.z.string().nullish(),
    locationId: _zod.z.string().nullish(),
    procedureTypeId: _zod.z.string().nullish(),
    physicianId: _zod.z.string().nullish(),
    anaesthetistId: _zod.z.string().nullish(),
    anaestheticId: _zod.z.string().nullish(),
    departmentId: _zod.z.string().nullish(),
    assistantAnaesthetistId: _zod.z.string().nullish(),
    timeIn: _zod.z.string().nullish(),
    timeOut: _zod.z.string().nullish(),
    // Related entities
    procedureType: _referenceDataschema.ReferenceDataSchema.nullish(),
    leadClinician: _userschema.UserSchema.nullish()
});

//# sourceMappingURL=procedure.schema.js.map