"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    DOSE_AND_RATE_TYPES: function() {
        return DOSE_AND_RATE_TYPES;
    },
    DOSE_AND_RATE_TYPES_SYSTEM: function() {
        return DOSE_AND_RATE_TYPES_SYSTEM;
    },
    FhirDoseAndRate: function() {
        return FhirDoseAndRate;
    }
});
const _yup = /*#__PURE__*/ _interop_require_wildcard(require("yup"));
const _baseType = require("./baseType");
const _codeableConcept = require("./codeableConcept");
const _quantity = require("./quantity");
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
const DOSE_AND_RATE_TYPES = {
    CALCULATED: {
        code: 'calculated',
        display: 'Calculated'
    },
    ORDERED: {
        code: 'ordered',
        display: 'Ordered'
    }
};
const DOSE_AND_RATE_TYPES_SYSTEM = 'https://hl7.org/fhir/R4B/codesystem-dose-rate-type.html';
let FhirDoseAndRate = class FhirDoseAndRate extends _baseType.FhirBaseType {
    static SCHEMA() {
        return _yup.object({
            type: _codeableConcept.FhirCodeableConcept.asYup().nullable().default(null),
            dose: _yup.object({
                doseQuantity: _quantity.FhirQuantity.asYup().nullable().default(null)
            }).nullable().default(null)
        }).noUnknown();
    }
    constructor(data){
        super({
            ...data,
            type: new _codeableConcept.FhirCodeableConcept({
                coding: [
                    {
                        system: DOSE_AND_RATE_TYPES_SYSTEM,
                        code: DOSE_AND_RATE_TYPES.ORDERED.code,
                        display: DOSE_AND_RATE_TYPES.ORDERED.display
                    }
                ]
            })
        });
    }
    static fake() {
        return new this({
            type: _codeableConcept.FhirCodeableConcept.fake(),
            dose: {
                doseQuantity: _quantity.FhirQuantity.fake()
            }
        });
    }
};

//# sourceMappingURL=doseAndRate.js.map