"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "FhirEncounterLocation", {
    enumerable: true,
    get: function() {
        return FhirEncounterLocation;
    }
});
const _lodash = require("lodash");
const _yup = /*#__PURE__*/ _interop_require_wildcard(require("yup"));
const _constants = require("@tamanu/constants");
const _baseType = require("./baseType");
const _codeableConcept = require("./codeableConcept");
const _period = require("./period");
const _reference = require("./reference");
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
const STATUS = Object.values(_constants.FHIR_ENCOUNTER_LOCATION_STATUS);
let FhirEncounterLocation = class FhirEncounterLocation extends _baseType.FhirBaseType {
    static SCHEMA() {
        return _yup.object({
            location: _reference.FhirReference.asYup().required(),
            status: _yup.string().oneOf([
                null,
                ...STATUS
            ]).required(),
            form: _codeableConcept.FhirCodeableConcept.asYup().nullable().default(null),
            period: _period.FhirPeriod.asYup().nullable().default(null),
            physicalType: _codeableConcept.FhirCodeableConcept.asYup().nullable().default(null)
        }).noUnknown();
    }
    static fake(model, { fieldName }, id) {
        return new this({
            location: _reference.FhirReference.fake('Location', {
                fieldName
            }, id),
            status: (0, _lodash.sample)(STATUS)
        });
    }
};

//# sourceMappingURL=encounterLocation.js.map