"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "getPatientDataDbLocation", {
    enumerable: true,
    get: function() {
        return getPatientDataDbLocation;
    }
});
const _constants = require("@tamanu/constants");
const getPatientDataDbLocation = async (fieldName, models)=>{
    // Look up the field in the models
    if (fieldName in _constants.PATIENT_DATA_FIELD_LOCATIONS) {
        const [modelName, columnName] = _constants.PATIENT_DATA_FIELD_LOCATIONS[fieldName];
        return {
            modelName,
            fieldName: columnName
        };
    }
    // Look up the field in custom patient fields
    const isCustomPatientField = await models.PatientFieldDefinition.findByPk(fieldName);
    if (isCustomPatientField) {
        return {
            modelName: 'PatientFieldValue',
            fieldName
        };
    }
    return {
        modelName: null,
        fieldName: null
    };
};

//# sourceMappingURL=getPatientDataDbLocation.js.map