"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    getDiscountAmount: function() {
        return getDiscountAmount;
    },
    getDiscountedPrice: function() {
        return getDiscountedPrice;
    },
    getInvoiceLevelDiscountAmount: function() {
        return getInvoiceLevelDiscountAmount;
    }
});
const _decimal = /*#__PURE__*/ _interop_require_default(require("decimal.js"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const getDiscountAmount = (price, percentDiscount)=>{
    return new _decimal.default(price).times(percentDiscount).toNumber();
};
const getDiscountedPrice = (price, percentDiscount)=>{
    return new _decimal.default(price).minus(getDiscountAmount(price, percentDiscount)).toNumber();
};
const getInvoiceLevelDiscountAmount = (discount, total)=>{
    return getDiscountAmount(total || 0, discount?.percentage || 0);
};

//# sourceMappingURL=discount.js.map