"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    formatDisplayPrice: function() {
        return formatDisplayPrice;
    },
    getFormattedInvoiceItemCoverageAmount: function() {
        return getFormattedInvoiceItemCoverageAmount;
    },
    getFormattedInvoiceItemNetCost: function() {
        return getFormattedInvoiceItemNetCost;
    },
    getInvoiceItemDiscountPriceDisplay: function() {
        return getInvoiceItemDiscountPriceDisplay;
    },
    getInvoiceItemPriceDisplay: function() {
        return getInvoiceItemPriceDisplay;
    },
    getInvoiceSummaryDisplay: function() {
        return getInvoiceSummaryDisplay;
    },
    round: function() {
        return round;
    }
});
const _lodash = require("lodash");
const _decimal = /*#__PURE__*/ _interop_require_default(require("decimal.js"));
const _invoice = require("./invoice");
const _invoiceItem = require("./invoiceItem");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const round = (value, decimals = 2)=>{
    return new _decimal.default(value).toNearest(new _decimal.default(10).pow(-decimals)).toNumber();
};
const formatDisplayPrice = (value)=>{
    if (isNaN(parseFloat(value))) {
        return undefined;
    }
    const normalisedValue = parseFloat(value);
    return normalisedValue.toLocaleString('en-US', {
        minimumFractionDigits: 2,
        maximumFractionDigits: 2
    });
};
const getInvoiceSummaryDisplay = (invoice)=>{
    const summary = (0, _invoice.getInvoiceSummary)(invoice);
    return (0, _lodash.mapValues)(summary, (value)=>formatDisplayPrice(value));
};
const getInvoiceItemPriceDisplay = (invoiceItem)=>{
    const rawPriceValue = (0, _invoiceItem.getInvoiceItemTotalPrice)(invoiceItem);
    const unformattedPrice = isNaN(parseFloat(rawPriceValue)) ? undefined : (0, _invoiceItem.getInvoiceItemTotalPrice)(invoiceItem);
    return formatDisplayPrice(unformattedPrice);
};
const getInvoiceItemDiscountPriceDisplay = (invoiceItem)=>{
    return formatDisplayPrice(isNaN(parseFloat(invoiceItem?.discount?.amount)) ? undefined : (0, _invoiceItem.getInvoiceItemTotalDiscountedPrice)(invoiceItem));
};
const getFormattedInvoiceItemCoverageAmount = (item)=>{
    if (!item?.product?.insurable || !item.insurancePlanItems?.length) {
        return formatDisplayPrice(0);
    }
    const coverage = (0, _invoiceItem.getItemTotalInsuranceCoverageAmount)(item);
    return formatDisplayPrice(-coverage);
};
const getFormattedInvoiceItemNetCost = (item)=>{
    const netCost = (0, _invoiceItem.getInvoiceItemNetCost)(item);
    return formatDisplayPrice(netCost);
};

//# sourceMappingURL=display.js.map